clear all
close all

direc='~/Documents/School/MS Research/Stats/WindSpeedsSummer.csv';
data=importdata(direc,',');

longs=[1 2 7 8 9 10 15 16 17 18 23 24];
shorts=[3 4 5 6 11 12 13 14 19 20 21 22];

intv=1.5;
rng=[0:intv:21];
counter=1;

pdf_store_long=nan*ones(15,length(longs));
pdf_store_short=nan*ones(15,length(shorts));
stdv_store_long=nan*ones(length(longs),1);
k_store_long=nan*ones(length(longs),1);
c_store_long=nan*ones(length(longs),1);
avg_store_long=nan*ones(length(longs),1);
weib_store_long=nan*ones(15,length(longs));

for jj=longs
    %Histogram
    hist_wind=hist(data(:,jj), rng);
    pdf_wind=(hist_wind)./(numel(data(:,jj))*intv);
    pdf_store_long(:,counter)=pdf_wind';

    %Weibull
    stdv=nanstd(data(:,jj));
    avg=nanmean(data(:,jj));
    k=(stdv/avg)^-1.086;
    c=avg*(0.568+(0.433/k))^(-1/k);
    weib=(k/c).*(rng./c).^(k-1).*exp(-(rng./c).^k);
    stdv_store_long(counter,1)=stdv;
    k_store_long(counter,1)=k;
    c_store_long(counter,1)=c;
    avg_store_long(counter,1)=avg;
    weib_store_long(:,counter)=weib';
    
    counter=counter+1;
end

%bar(rng,pdf_wind)



%direc='~/Desktop/winter_wind.txt';
% direc='~/Documents/School Work/Atmospheric Science/Research/Stats/winter_wind_09.txt';
% result=fileread(direc);
% data=regexp(result, '\r\n|\r|\n', 'split');
% counter=1;
% for dd=8:9:size(data,2);
%     wind(counter)=str2double(data{1,dd}(6:10));
%     counter=counter+1;
% end
% 
% %Histogram
% intv=1.5;
% rng=[0:intv:21];
% hist_wind=hist(wind,rng);
% pdf_wind=(hist_wind)./(numel(wind)*intv);
% bar(rng,pdf_wind)
% 
% %Weibull Dist'n
% stdv=std(wind);
% avg=mean(wind);
% k=(stdv/avg)^-1.086;
% c=avg*(0.568+(0.433/k))^(-1/k);
% weib=(k/c).*(rng./c).^(k-1).*exp(-(rng./c).^k);
% 
% weib'

